'----MAKE BMX VERSION - by martin dombrowa----------------------------------------------------
'----create versions from your daily works with buzz using a template bmx file----------------------
'---------------------------------------------------------------------------------------------------
'----this script creates bmx/folder from a template named by the current date in a defined workdir--
'----and if executed again creates versions of the last accessed bmx file named by the current day--
'---------------------------------------------------------------------------------------------------
Set objWMIService = GetObject("winmgmts:\\" & "." & "\root\cimv2")
Set dateItems = objWMIService.ExecQuery("Select * from Win32_OperatingSystem")
Set oFSO = CreateObject("Scripting.FileSystemObject")
Dim strMbox
'----Environment------------------------------------------------------------------------------------
bmxWorkDir = "e:\producing\xd\bmx\temp\"
bmxTemplateName = "xxxxxx_00.bmx" 'template must be placed in workdirs root
'---------------------------------------------------------------------------------------------------
For Each objItem in dateItems
    dtmLocalTime = objItem.LocalDateTime
    dtmYear = Mid(dtmLocalTime, 3, 2)
	dtmMonth = Mid(dtmLocalTime, 5, 2)
    dtmDay = Mid(dtmLocalTime, 7, 2)
Next
currentDate = dtmYear & dtmMonth & dtmDay
'---------------------------------------------------------------------------------------------------
lastbmxDir = bmxWorkDir & dtmYear & "\" & currentDate
bmxTemplateSrc = bmxWorkDir & bmxTemplateName
bmxTemplateDest = bmxWorkDir & dtmYear & "\" & currentDate & "\" & currentDate & "_01.bmx"
If oFSO.FolderExists(lastbmxDir) Then
   Set oFolder = oFSO.GetFolder(lastbmxDir)
Else
   Set oFolder = oFSO.CreateFolder(lastbmxDir) 
End If

lastbmx = GetNewestFile(lastbmxDir)
bmxFile = lastbmxDir & "\" & Left(Right(lastbmx, 13) , 6)
bmxVersion = Left(Right(lastbmx, 6), 2)
 If bmxVersion = "" Then
 bmxVersion = "00"
 End If
'---------------------------------------------------------------------------------------------------

If lastbmx <> "" Then
   'WScript.Echo "Latest file is " & Left(Right(lastbmx, 13) , 9)
   dFileModDate = oFSO.GetFile(lastbmx).DateLastAccessed 
   If bmxVersion >= "09" Then
   newbmx = bmxFile & "_" & bmxVersion +1 & ".bmx"
   Else
   newbmx = bmxFile & "_0" & bmxVersion +1 & ".bmx"
   End If
   oFSO.CopyFile lastbmx , newbmx
End If
If lastbmx = "" Then
oFSO.CopyFile bmxTemplateSrc , bmxTemplateDest
   End If

'---------------------------------------------------------------------------------------------------
Function GetNewestFile(ByVal lastbmxDir)
   lastbmx = Null
   
   Set oFolder = oFSO.GetFolder(lastbmxDir)
   Set oFiles = oFolder.Files

   For Each oFile In oFiles
     On Error Resume Next
     If IsNull(lastbmx) Then
       lastbmx = oFile.Path
       dPrevDate = oFile.DateLastAccessed
     Elseif dPrevDate < oFile.DateLastAccessed Then
       lastbmx = oFile.Path
     End If
     On Error Goto 0
   Next
   If IsNull(lastbmx) Then lastbmx = ""
   GetNewestFile = lastbmx
End Function
'---------------------------------------------------------------------------------------------------
strMbox = MsgBox(currentDate & " Version " & bmxVersion +1 & " created ! " & chr(13) & chr(13) & "Load bmx now ?", vbQuestion + vbOKCancel)
If strMbox = 1 Then
Set objShell = CreateObject("WScript.Shell")
If newbmx = "" Then newbmx = lastbmxDir & "\" & currentDate & "_01.bmx"
objShell.run (newbmx)
End If
